/////////////////////////////////////////////////////////////////////////////////

// Original obtained from ShaderToy.com
// Adapted, trivialy, for VGHD by TheEmu.

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// Use defines here rather than edit the body of the code.

#define iGlobalTime u_Elapsed
#define iResolution u_WindowSize

/////////////////////////////////////////////////////////////////////////////////

#define StepSize 0.95
#define LineCount 6

//Function to draw a line, taken from the watch shader
float line(vec2 p, vec2 a, vec2 b)
{
	vec2 pa = p - a;
	vec2 ba = b - a;
	float h = clamp(dot(pa, ba) / dot(ba, ba), 0.0, 1.0);
	return pow(clamp(1.0-length(pa - ba * h),0.0,1.0),6.0)*(8.0-distance(a,b)+abs(h-.5))*.5;
}

float point(vec2 uv, vec2 p, float gt)
{
    return pow(clamp(0.44*(2.2-distance(p,uv)),0.0,1.0),4.0+3.0*sin(gt));
}

void main ( void )
{
	vec2 uv = (gl_FragCoord.xy / iResolution.xy) * 9.0 - 4.5;

	float gt = iGlobalTime * 5.0;
    //gt -= mod(gt,StepSize);

	// Add lines to the pixel
	vec3 color = vec3(0.0, 0.0, 0.0);
    vec2 point3 = 2.3 * vec2(sin(gt * 0.39), cos(gt * 0.63)) + 1.7*vec2(sin(gt * 0.27), cos(gt * 0.33));
	for (int i = 0; i < LineCount; i++)
	{
		gt += StepSize;

		//Calculate the next two points
	    vec2 point1 = 2.3 * vec2(sin(gt * 0.39), cos(gt * 0.63)) + 1.7*vec2(sin(gt * 0.27), cos(gt * 0.33));
	  	vec2 point2 = 2.3 * vec2(cos(gt * 0.69), sin(gt * 0.29)) + 1.7*vec2(sin(gt * 0.19), cos(gt * 0.23));

		// Fade older lines
		color.rgb = 0.75 * color.rgb;

		// Add new line
		color.rgb += (point(uv, point1, gt)
                     +line(	uv,
							point1, point2)
                     +point(uv, point2, gt))
					//With color
					* ( 0.5 +
						0.5 * (vec3(sin(float(i) * 3.13),
									cos(float(i) * 1.69),
									cos(float(i) * 2.67))));
        point3 = point1;
    }

	// Clamp oversaturation
	gl_FragColor.rgb = clamp(color, 0.0, 1.0);
   gl_FragColor.a = length(color);

}